package myposhbot;

import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Ammo;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.introspection.PogProp;
import java.util.ArrayList;
import java.util.List;
import cz.cuni.sposhBot.java.JavaBehaviour;
import java.util.logging.Logger;

/**
 * Here is the place to implement your acts and senses
 * The log domain of a behaviour is set to class name.
 *
 * act:
 *     in plan file: shoot
 *     in behaviour: public void action_shoot()
 * sense:
 *     in plan file: hear
 *     in behaviour: public boolean sense_hear()
 *
 * E.g. see action_doNothing() /  sense_fail()
 */
public class MyBehaviour extends JavaBehaviour {
    protected Player enemy = null;
    protected Player remembered_enemy = null;
    protected ArrayList<Item> mem_healths;
    protected ArrayList<Weapon> mem_weapons;
    protected ArrayList<Ammo> mem_ammos;
    protected Listener EListener;
    protected long pursuit_start = 0;
    protected long not_moved_start = 0;
    protected Triple possibly_stuck_at = new Triple(0, 0, 0);
    protected Item interesting_item = null;
    protected Item chosen_medkit = null;
    protected boolean dodge_left = false;
    protected boolean should_look_behind = false;
    @PogProp
    protected boolean fire_at_will = true;
    protected boolean bumped = false;
    @PogProp
    protected int agent_health = 100;
    protected boolean should_immediately_dodge;     
    
    public MyBehaviour(String name, Logger log, Main bot) {
        super(name, log, bot);
        memory = bot.getMemory();
        body = bot.getBody();
        this.agent = bot;        
        InitItemsMemory();
        EListener = new Listener();
    }    
    
    AgentMemory memory = null;
    AgentBody body = null;
    Main agent = null;
    
    protected void InitItemsMemory() {
        log.warning("InitItemsMemory");
        mem_ammos = memory.getKnownAmmos();
        mem_weapons = memory.getKnownWeapons();
        mem_healths = memory.getKnownItemsOfType(MessageType.HEALTH);
        mem_healths.addAll(memory.getKnownItemsOfType(MessageType.ARMOR));
    }      

    public boolean action_dodge_to_side() {
        dodge_to(0);
        return true;
    }

    public boolean action_double_jump() {
        body.doubleJump();
        return true;
    }

    public boolean action_look_behind() {
        if (should_look_behind) {
            should_look_behind = false;
            body.turnHorizontal(179);
        }
        return true;
    }

    public boolean action_choose_enemy() {
        if (memory.getSeePlayers().size() == 0) {
            if (enemy != null) {
                log.warning("I dont see enemy: " + enemy.name);
                pursuit_start = System.currentTimeMillis();
                remembered_enemy = enemy;
                enemy = null;
            }
            body.stopShoot();            
            return false;
        }        
        
        List<Player> players = memory.getSeePlayers();
        Player closest_player = null;
        double closest_player_distance = 0;
        double distance = 0;
        for (Player player : players) {
            distance = Triple.distanceInSpace(player.location, memory.getAgentLocation());
            if (closest_player == null ||
                    distance < closest_player_distance) {
                closest_player = player;
                closest_player_distance =
                        Triple.distanceInSpace(memory.getAgentLocation(), player.location);
            }            
        }
        if ((enemy == null) || (enemy != null && 2*Triple.distanceInSpace(enemy.location, memory.getAgentLocation()) <
            Triple.distanceInSpace(closest_player.location, memory.getAgentLocation()))) {
            enemy = closest_player;
        }
        return (enemy != null);
    }
        
    public boolean action_dodge_bullets() {
        should_immediately_dodge = false;
        action_dodge_to_side();
        body.jump();
        return true;
    }
    
    public boolean action_attack_dodge() {
        dodge_to(1);
        return true;
    }
    
    public boolean action_fire_at_enemy() {
        if (enemy == null) {
            return false;
        }
        log.warning("Action; Firing on enemy: " + enemy.name);
        AddWeapon possible_weapon = memory.getBetterWeapon(memory.getAgentLocation(), enemy.getLocation());
        if (possible_weapon != null && possible_weapon.isLoaded()) {
            body.changeWeapon(possible_weapon);
            log.info("pos_weapon: " + possible_weapon.isLoaded() + " has " + possible_weapon.currentAmmo);
        }
        else log.info("No better weapon");
        
        if (memory.getCurrentWeapon().isLoaded()) {
            log.warning("Weapon loaded");
            body.shoot(enemy);
        } else {
            log.warning("Weapon not loaded");
            if (sense_shield_is_cooled_down())
                action_use_shield();            
        }
        return true;
    }

    public boolean action_use_shield() {
        body.changeWeapon(memory.getWeapon(ItemType.SHIELD_GUN));
        body.shootAlternate(enemy);
        return true;
    }

    public boolean sense_bumped() {
        //return !(bumped = !bumped);
        return false;
    }

    public boolean sense_should_immediately_dodge() {
        boolean ret = should_immediately_dodge;
        should_immediately_dodge = false;
        return ret;
    }

    public boolean sense_should_look_behind() {
        if (should_look_behind && memory.getSeePlayers().size() == 0) return true;
        should_look_behind = false;
        return false;
    }

    public boolean sense_shield_is_cooled_down() {
        return memory.getWeapon(ItemType.SHIELD_GUN).currentAmmo > 50;
    }

    public boolean sense_stuck() {
        if (Triple.distanceInSpace(possibly_stuck_at, memory.getAgentLocation()) < 50) {
            if (System.currentTimeMillis() - not_moved_start > 2 * 1000) {
                return true;
            } else {
                return false;
            }
        }
        possibly_stuck_at = memory.getAgentLocation();
        not_moved_start = System.currentTimeMillis();
        return false;
    }

    public boolean action_flee_fighting() {
        if (enemy == null) return false;
        Triple agent_loc = memory.getAgentLocation();
        if (chosen_medkit == null ||
                Triple.distanceInSpace(agent_loc, chosen_medkit.location) < 50) {
            double dot = 0;
            double min_dot = 0;
            for (Item health : mem_healths) {
                dot = (Triple.subtract(enemy.location, agent_loc)).dot(health.location);
                if (!(Triple.distanceInSpace(agent_loc, health.location) < 100 &&
                        memory.getSeeHealth(health.UnrealID) == null) &&
                        chosen_medkit == null || dot < min_dot) {
                    min_dot = dot;
                    chosen_medkit = health;
                }
            }
        }

        if (chosen_medkit != null) {
            log.severe("RUNNING TO MEDPAK at " + chosen_medkit.location.toString() + "!!!!");
            agent.gameMap.safeStrafeToLocation(chosen_medkit.location, enemy.location);
        } else {
            log.severe("NO MEDPAK FOUND!!!! JUST BACKPEDALLING");            
            Triple strafe_target = Triple.subtract(agent_loc, enemy.location);
            body.strafeToLocation(strafe_target, enemy.location);
        }
        //body.doubleJump();
        return true;
    }

    public boolean action_getExtra() {
        Item extra = memory.getSeeExtra();
        if (extra != null) {
            agent.gameMap.safeRunToLocation(extra.location);
        }
        return true;
    }

    public boolean action_pursue() {
        log.info("Pursuit");
        return (remembered_enemy != null && agent.gameMap.safeRunToLocation(remembered_enemy.location));
    }

    public boolean sense_pursuit_possible() {
        String logline = "Sense pursuit possible: ";
        if (remembered_enemy != null) {
            if (Triple.distanceInSpace(remembered_enemy.location, memory.getLocation().getFlag()) < 50 ||
                    System.currentTimeMillis() - pursuit_start > 7 * 1000) {
                remembered_enemy = null;
                pursuit_start = 0;
                log.info(logline + "false");
                return false;
            }
            log.info(logline + "true");
            return true;
        }
        log.info(logline + "false");
        return false;
    }

    public boolean sense_see_extra() {
        return memory.getSeeAnyExtra();
    }

    public boolean sense_should_be_aggressive() {
        return (sense_enough_weapons() && memory.getAgentHealth() > 50);
    }

    public boolean sense_enough_weapons() {
        log.warning("Sense: enough weapons" + (memory.getAllWeapons().size() > 4));
        return (memory.getAllWeapons().size() > 4);
    }

    public boolean sense_enough_life() {
        log.warning("Sense: enough life " + (memory.getHealth().getFlag() > 30));
        return (memory.getHealth().getFlag() > 30);
    }

    public boolean action_attack() {
        log.warning("Action: attack");        
        if (enemy != null) {
            log.warning("Got enemy: " + enemy.name);
            remembered_enemy = enemy;
            //if (memory.getSeePlayer(enemy.ID) != null) {
            body.runToTarget(enemy);
            return true;
        }
        return false;
    }

    public boolean action_getMedkit() {
        log.warning("Action: getMedkit");
        Item medkit = memory.getSeeReachableArmor();
        if (medkit == null) {
            medkit = memory.getSeeReachableHealth();
        }
        if (medkit != null) {
            return agent.gameMap.safeRunToLocation(medkit.location);
        } else {
            agent.gameMap.runAroundItemsInTheMap(mem_healths, true);
            return true;
        }
    }

    public boolean action_getWeapons() {
        log.warning("Action: getWeapon");
        ArrayList<Weapon> weapons = memory.getSeeReachableWeapons();
        if (!weapons.isEmpty()) {
            agent.gameMap.runAroundItemsInTheMap(weapons, true);
        } else {
            agent.gameMap.runAroundItemsInTheMap(mem_weapons, true);
        }
        return true;
    }

    public boolean action_getAmmo() {
        log.warning("Action: getAmmo");
        ArrayList<Ammo> ammos = memory.getSeeReachableAmmos();
        if (!ammos.isEmpty()) {
            agent.gameMap.runAroundItemsInTheMap(ammos, true);
        } else {
            agent.gameMap.runAroundItemsInTheMap(mem_ammos, true);
        }
        return true;
    }

    public boolean action_run_to_interesting_item() {
        log.severe("Action: run to interesting item");
        Health see_health = memory.getSeeReachableHealth();
        if (memory.getHealth().getFlag() < 50 && see_health != null) {
            agent.gameMap.safeRunToLocation(see_health.location);
            return true;
        }

        ArrayList<Item> see_items = memory.getSeeItems();
        Item nearest_item = null;
        double nearest_distance = 0;
        for (Item item : see_items) {
            if (!is_useful_item(item)) {
                continue;
            }
            double curr_distance = Triple.distanceInSpace(memory.getAgentLocation(), item.location);
            if (nearest_item == null || nearest_distance > curr_distance) {
                nearest_item = item;
                nearest_distance = curr_distance;
            }
        }
        if (nearest_item != null) {
            return agent.gameMap.safeRunToLocation(nearest_item.location);
        }
        return false;
    }

    public boolean sense_see_enemy() {
        //log.warning("Sense: see enemy "+(memory.getSeeAnyEnemy()));
        //boolean ret = memory.getSeeAnyPlayer();
        log.warning("Sense: see enemy " + (memory.getSeePlayers().size() > 0));
        boolean ret = memory.getSeePlayers().size() > 0;
        if (!ret) {
            body.stopShoot();
            enemy = null;
        }
        return ret;
    }

    public boolean sense_see_health() {
        log.warning("Sense: see health" + (memory.getSeeReachableHealth() != null));
        return memory.getSeeReachableHealth() != null;
    }

    public boolean sense_see_interesting_item() {
        log.warning("Sense: see interesting item");
        if (memory.getHealth().getFlag() < 100) {
            return sense_see_health();
        }
        ArrayList<Item> items = memory.getSeeItems();

        for (Item item : items) {
            if (is_useful_item(item)) {
                return true;
            }
        }
        return false;
    }

    public boolean sense_see_useful_ammo() {
        ArrayList<Ammo> ammos = memory.getSeeAmmos();
        for (Ammo ammo : ammos) {
            AddWeapon weapon = memory.getWeapon(ammo.typeOfWeapon);
            if (weapon != null &&
                    weapon.currentAmmo /
                    weapon.maxAmmo < .50) {
                log.info("Sense: sense_see_useful_ammo true");
                return true;
            }
        }
        log.info("Sense: sense_see_useful_ammo false");
        return false;
    }

    public boolean sense_fleeing() {
        if (!sense_should_be_aggressive() && remembered_enemy != null) {
            if (System.currentTimeMillis() - pursuit_start > 7 * 1000) {
                remembered_enemy = null;
                pursuit_start = 0;
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }
    
    public boolean sense_see_enemy_or_pursuit() {
        return sense_see_enemy() || sense_pursuit_possible();
    }
    
    public boolean sense_need_medpak_urgently() {
        return memory.getAgentHealth() < 50;
    }

    @Override
    public boolean sense_fail() {
        return false;
    }
    
    public boolean sense_success() {
        return true;
    }
    
    protected boolean is_useful_medpak(Item medpak) {
        return  is_armor(medpak) || ((is_medpak(medpak)) && is_useful_medpak((Health) medpak));
    }

    protected boolean is_useful_medpak(Health medpak) {
        if (medpak.getType().toString().equals("MINI_HEALTH_PACK")) {
            return true;
        }
        if (memory.getHealth().getFlag() > 90) {
            return false;
        }
        return true;
    }

    protected boolean is_useful_weapon(Item weapon) {
        return (weapon.getType().equals(MessageType.WEAPON)) ? is_useful_weapon((Weapon) weapon) : false;
    }

    protected boolean is_useful_weapon(Weapon weapon) {
        return (memory.getWeapon(weapon.getWeaponType())) == null;
    }

    protected boolean is_medpak(Item medpak) {
        return medpak.getType().equals(MessageType.HEALTH);
    }

    protected boolean is_weapon(Item weapon) {
        return weapon.getType().equals(MessageType.WEAPON);
    }

    protected boolean is_armor(Item armor) {
        return armor.getType().equals(MessageType.ARMOR);
    }

    protected boolean is_useful_item(Item item) {
        if (is_useful_medpak(item) || is_useful_weapon(item)) {
            return true;
        }
        if (!is_medpak(item) && !is_weapon(item)) {
            return true;
        }        
        return false;
    }
    
    protected boolean dodge_to(double y_deviation) {
        body.dodge(dodge_left ? new Triple(1, y_deviation, 0) : new Triple(-1, y_deviation, 0));
        dodge_left = !dodge_left;
        return true;
    }    
    
    protected class Listener implements RcvMsgListener {

        public Listener() {
            body.addRcvMsgListener(this);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            // spravne je INCOMING
            switch (e.getMessage().type) {
                case INCOMMING_PROJECTILE:
                    should_immediately_dodge = true;
                    log.info("AAAAAAAAAAAAA RAKETU NEEEEEE!!!");
                    break;
                case HEAR_NOISE:
                case BOT_DAMAGED:
                    should_look_behind = true;
                    agent_health = memory.getAgentHealth();
                    log.info("LOOK BEHIND");
                    break;

                case BOT_KILLED:
                    synchronized (this) {
                        remembered_enemy = null;
                        enemy = null;
                        interesting_item = null;
                        chosen_medkit = null;
                        bumped = false;
                        possibly_stuck_at = new Triple(0, 0, 0);
                    }
                    log.info("DIED :(");
                    break;

                case BUMPED:
                    bumped = true;
                    log.info("BUMPED");
                    break;

            }
        }
    }    
}
